from typing import Text, Any


# This is a custom refiner function.
#
# - It takes a single argument (name)
# - It accepts **kwargs so that extra arguments in refiner don't accidentally crash it.
# - It returns a string
#
def custom_greeting(name, **kwargs):
  # type: (Text, **Any) -> Text
  return "Hello, {}!".format(name)


# This is a custom refiner function.
#
# - It takes two regular arguments (find_in_text, query)
# - It takes a special refiner variable that maps to the set of refiner functions.
#   By passing in this variable your custom functions can rely on other refiner functions.
# - It accepts **kwargs so that extra arguments in refiner don't accidentally crash it.
# - It returns the result of the refiner function call
def custom_find(find_in_text, query, REFINER_FNS, **kwargs):
  # type: (Text, Text, Any, **Any) -> Text
  return REFINER_FNS.call('scan_right', find_in_text, query)


# This is the registration block for the custom refiner functions
def register(name_to_fn):
  # type: (Any) -> None
  more_fns = {
      'custom_greeting': {
          'fn': custom_greeting,
          'ex': '',
          'desc': ''
      },
      'custom_find': {
          'fn': custom_find,
          'ex': '',
          'desc': ''
      }
  }
  name_to_fn.update(more_fns)
